<?php
/**
 * @class smsbao
 * @brief 短信发送接口 http://api.smsbao.com/sms
 */
class smsbao extends hsmsBase
{
    private $submitUrl  = "http://api.smsbao.com/sms";
    /**
     * @brief 获取config用户配置
     * @return array
     */
    public function getConfig()
    {
        $siteConfigObj = new Config("site_config");

        return array(
            'username' => $siteConfigObj->sms_username,
            'userpwd'  => $siteConfigObj->sms_pwd,
            'sign'  => $siteConfigObj->sms_sign,
        );
    }

    /**
     * @brief 发送短信
     * @param string $mobile
     * @param string $content
     * @return
     */
    public function send($mobile,$content)
    {
        $config = self::getConfig();

        $post_data = array(
            'u' => $config['username'],
            'p' => $config['userpwd'],
            'c'  => '【'.$config['sign'].'】'.$content,
            'm'   => $mobile,
        );

        $url    = $this->submitUrl;
        $string = '';
        foreach ($post_data as $k => $v)
        {
            $string .="$k=".urlencode($v).'&';
        }

        $post_string = substr($string,0,-1);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); //如果需要将结果直接返回到变量里，那加上这句。
        $result = curl_exec($ch);
        return $this->response($result);
    }

    /**
     * @brief 解析结果
     * @param $result 发送结果
     * @return string success or fail
     */
    public function response($result)
    {
        if(trim($result) =='0')
        {
            return 'success';
        }
        else
        {
            return $this->getMessage($result);
        }
    }

    /**
     * @brief 获取参数
     */
    public function getParam()
    {
        return array(
            "username" => "用户名",
            "userpwd"  => "密码",
            "usersign" => "短信签名",
        );
    }


    //返回消息提示
    public function getMessage($code)
    {
        $messageArray = array(
            -1 =>"参数不全",
            30  =>"密码错误",
            40  =>"账号不存在",
            41  =>"余额不足",
            42  =>"账号过期",
            43  =>"IP地址限制",
            50  =>"内容含有敏感词",
            51 =>"手机号码不正确",
        );
        return isset($messageArray[$code]) ? $messageArray[$code] : "未知错误";
    }
}
