<?php
/**
 * Niushop商城系统 - 团队十年电商经验汇集巨献!
 * =========================================================
 * Copy right 2019-2029 杭州牛之云科技有限公司, 保留所有权利。
 * ----------------------------------------------
 * 官方网址: https://www.niushop.com
 * =========================================================
 */

namespace addon\smsbao\model;

use app\model\BaseModel;
use Overtrue\EasySms\EasySms;
use Overtrue\EasySms\Exceptions\InvalidArgumentException;
use Overtrue\EasySms\Exceptions\NoGatewayAvailableException;
use Overtrue\EasySms\Strategies\OrderStrategy;

/**
 * 短信宝短信
 */
class Sms extends BaseModel
{
    /**
     * 短信发送
     * @param array $param
     * @return array|mixed
     * @throws InvalidArgumentException
     */
    public function send($param = [])
    {

        $config_model = new Config();
        $config_result = $config_model->getSmsConfig();
        if ($config_result[ "data" ][ "is_use" ]) {
            $config = $config_result[ "data" ][ "value" ];
            $sms_info = $param[ "message_info" ][ "sms_json_array" ];//消息类型模板 短信模板信息
            if (empty($sms_info[ "smsbao" ])) return $this->error([], "消息模板尚未配置");
            $sms_info = $sms_info[ "smsbao" ];
            $var_parse = $param[ "var_parse" ];//变量解析
            $smscontent = $sms_info['content'];
            foreach ($var_parse as $k=>$v){
                $smscontent=str_replace('{'.$k.'}',$v,$smscontent);
            }
            $account = $param[ "sms_account" ];//发送手机号
            $sms_config = [
                // HTTP 请求的超时时间（秒）
                'timeout' => 5.0,
                // 默认发送配置
                'default' => [
                    // 网关调用策略，默认：顺序调用
                    'strategy' => OrderStrategy::class,
                    // 默认可用的发送网关
                    'gateways' => [ 'smsbao' ],
                ],
                // 可用的网关配置
                'gateways' => [
                    "smsbao" => [
                        'user' => $config[ "smsbao_key_id" ],
                        'password' => $config[ "smsbao_key_secret" ],
                    ]
                ],
            ];

            try {
                $easySms = new EasySms($sms_config);
                $easySms->send($account, [
                    'content'  => '【'.$config[ "smsbaosign" ].'】'.$smscontent,
//                    'template' => $sms_info[ "template_id" ],
                    'data' => $var_parse,
                ]);
                return $this->success([ "addon" => "smsbao", "addon_name" => "短信宝短信", "content" => $sms_info[ "content" ] ]);
            } catch (NoGatewayAvailableException $exception) {
                $message = $exception->getException('smsbao')->getMessage();
                return $this->error([ "content" => $sms_info[ "content" ] ], $message ? : '短信发送异常');
            }
        }
    }
}
