<?php
namespace addons\smsbao;

use app\common\lib\Curl;
use app\base\model\Setting as ModelSetting;
use app\base\model\ShopLog;

class Smsbao
{
    private $config = [];
    protected $smsapi = "http://api.smsbao.com/sms?";
    protected $statusStr = array(
        "0" => "短信发送成功",
        "-1" => "参数不全",
        "-2" => "服务器空间不支持,请确认支持curl或者fsocket，联系您的空间商解决或者更换空间！",
        "30" => "密码错误",
        "40" => "账号不存在",
        "41" => "余额不足",
        "42" => "帐户已过期",
        "43" => "IP地址限制",
        "50" => "内容含有敏感词"
        );

    function __construct()
    {
        $this->config = [
            'username' => config('addons.smsbao.sms_account', ''),
            'apikey' => config('addons.smsbao.sms_password', ''),
        ];
    }

    public function send($data)
    {
        $content = $data['content'];
        $position = mb_strpos($content, '【');
        $content = mb_substr($content, 0, $position, "UTF-8");
        $prefix = ModelSetting::toGet('base.sms_prefix', '');
        if($prefix == ""){
            $prefix = ModelSetting::toGet("base.shop_name");
        }
        $content = '【' . $prefix . '】'.$content;
        $content = urlencode($content);
        $str     = $this->smsapi. "&u=" . $this->config['username'] . "&p=" . $this->config['apikey'] . "&mobile=" . $data['mobile'] . "&content=" . $content;
        $re      = Curl::get($str);
        if ($re == '0') {
            return recode(10000);
        }else{
             //如果发送短信失败，记录到系统日志，然后返回统一错误
            ShopLog::toAdd(
                "短信发送失败", 
                3, 
                $this->statusStr[$re], 
                json_encode($data)
            );
            return recode(11251);
        }
        
    }

}
