<?php

namespace app\common\server;
use think\Exception;

class Smsbao
{
    private $app_key = '';
    private $secret_key = '';
    private $sign = '';
    private $mobile = '';
    private $content= '';

    public function __construct($config)
    {
        $this->sign = $config['sign'];
        $this->app_key = $config['app_key'];
        $this->secret_key = $config['secret_key'];
    }
    public function setContent($template_code){
        $this->content = $template_code;
        return $this;
    }

    public function setMobile($mobile){
        $this->mobile = $mobile;
        return $this;
    }

    public function sendSms(){
        try {
            $statusStr = array(
                "0" => "短信发送成功",
                "-1" => "参数不全",
                "-2" => "服务器空间不支持,请确认支持curl或者fsocket，联系您的空间商解决或者更换空间！",
                "30" => "密码错误",
                "40" => "账号不存在",
                "41" => "余额不足",
                "42" => "帐户已过期",
                "43" => "IP地址限制",
                "50" => "内容含有敏感词"
            );
            $smsapi = "http://api.smsbao.com/";
            $user = $this->app_key; //短信平台帐号
            $pass = md5($this->secret_key); //短信平台密码
            $sign = '【'.$this->sign.'】'; //短信平台密码
            $content=$sign.$this->content;//要发送的短信内容
            $phone = $this->mobile;//要发送短信的手机号码
            $sendurl = $smsapi."sms?u=".$user."&p=".$pass."&m=".$phone."&c=".urlencode($content);
            $result = $this->curl_get($sendurl);
            $res = [];
            if ($result == 0){
                $res['Code'] ='OK';
            }else{
                $res['Code'] ='fail';
                $res['Message'] =$statusStr[$result];
            }
            return $res;

            // return $result->toArray();
        } catch(Exception $e){
            return $e->getMessage() . PHP_EOL;
        }
    }

      private function curl_get($sendurl){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $sendurl);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); //不验证证书
//        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); //不验证证书
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

}