<?php
namespace strategy\sms\impl;

use Darabonba\OpenApi\Models\Config;
use strategy\sms\SmsInterface;
use think\facade\Log;

class SmsbaoSmsImpl implements SmsInterface
{
    private $sendUrl = 'http://api.smsbao.com/sms?';

    private $statusStr = array(
                "0" => "短信发送成功",
                "-1" => "参数不全",
                "-2" => "服务器空间不支持,请确认支持curl或者fsocket，联系您的空间商解决或者更换空间！",
                "30" => "密码错误",
                "40" => "账号不存在",
                "41" => "余额不足",
                "42" => "帐户已过期",
                "43" => "IP地址限制",
                "50" => "内容含有敏感词",
                "51" => "手机号码不正确"
            );

     private function curl_get($sendurl){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $sendurl);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }
 
    public function send($param)
    {
        try {
            $user = $param["accessKeyId"];
            $apikey = $param["accessKeySecret"];
            $codeStr = $param["code"];
            $codeData = json_decode($codeStr,true);
            $TemplateContent = str_replace('{code}', $codeData['code'], $param["templateCode"]);
            $content = '【'.$param["signName"].'】'.$TemplateContent;
            $sendurl = $this->sendUrl."u=".$user."&p=".$apikey."&m=".$param["phone"]."&c=".urlencode($content);
            $result = $this->curl_get($sendurl);
            if ($result == 0) {
                return dataReturn(0, '发送成功');
            }else{
                 return dataReturn(-1, '发送失败:'.$this->statusStr[$result]);
            }
        } catch (\Exception $error) {
            Log::error("短信失败：" . $error->getMessage());
            return dataReturn(-1, '发送失败');
        }

        return dataReturn(0, '发送成功');
    }
}